
<?php $__env->startSection('page_title', __('label.system_settings')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">

            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.system_settings')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.system_settings')); ?></li>
                    </ol>
                </div>
            </div>

            <div class="row">
                <div class="col-6">
                    <div class="card custom-border-card">
                        <a data-bs-toggle="collapse" data-bs-target="#clear_data">
                            <h5 class="card-header"><i class="fa-solid fa-chevron-down float-right"></i><?php echo e(__('label.clear_cache')); ?></h5>
                        </a>

                        <div id="clear_data" class="collapse">
                            <div class="card-body">
                                <p><?php echo e(__('label.clear_cache_notes')); ?></p>
                                <div class="d-flex justify-content-end">
                                    <button type="button" class="btn btn-default mw-120" onclick="clear_data()"><?php echo e(__('label.clear_cache')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="card custom-border-card">
                        <a data-bs-toggle="collapse" data-bs-target="#download_database">
                            <h5 class="card-header"><i class="fa-solid fa-chevron-down float-right"></i><?php echo e(__('label.backup_database')); ?></h5>
                        </a>

                        <div id="download_database" class="collapse">
                            <div class="card-body">
                                <p><?php echo e(__('label.backup_database_notes')); ?></p>
                                <div class="d-flex justify-content-end">
                                    <a href="<?php echo e(route('system.setting.downloadsqlfile')); ?>" onclick="return confirm('<?php echo e(__('label.you_want_to_download_this_sql_file')); ?>')" class="btn btn-default mw-120"><?php echo e(__('label.download')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- <div class="col-6">
                    <div class="card custom-border-card">
                        <a data-bs-toggle="collapse" data-bs-target="#dummy_data">
                            <h5 class="card-header"><i class="fa-solid fa-chevron-down float-right"></i><?php echo e(__('label.dummy_data')); ?></h5>
                        </a>

                        <div id="dummy_data" class="collapse">
                            <div class="card-body">
                                <p><?php echo e(__('label.add_the_dummy_data_in_this_database')); ?></p>
                                <div class="d-flex justify-content-end">
                                    <button type="button" class="btn btn-default mw-120" onclick="dummy_data()"><?php echo e(__('label.insert_data')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->
                <div class="col-6">
                    <div class="card custom-border-card">
                        <a data-bs-toggle="collapse" data-bs-target="#clean_database">
                            <h5 class="card-header"><i class="fa-solid fa-chevron-down float-right"></i><?php echo e(__('label.clean_database')); ?></h5>
                        </a>

                        <div id="clean_database" class="collapse">
                            <div class="card-body">
                                <p><?php echo e(__('label.dalete_all_data_in_database')); ?></p>
                                <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-default mw-120" onclick="clean_database()"><?php echo e(__('label.clean_database')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>

        // Sidebar Scroll Down
        sidebar_down($(document).height());

        function clear_data() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                if (confirm("<?php echo e(__('label.do_you_confirm_clear_the_data')); ?>")) {
                    $("#dvloader").show();
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        enctype: 'multipart/form-data',
                        type: 'POST',
                        url: '<?php echo e(route("system.setting.cleardata")); ?>',
                        cache: false,
                        contentType: false,
                        processData: false,
                        success: function(resp) {
                            $("#dvloader").hide();
                            get_responce_message(resp, '', '<?php echo e(route("system.setting.index")); ?>');
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            $("#dvloader").hide();
                            toastr.error(errorThrown, textStatus);
                        }
                    });
                }
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        }
        function dummy_data() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                if (confirm("<?php echo e(__('label.do_you_confirm_insert_the_dummy_data')); ?>")) {

                    $("#dvloader").show();
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        enctype: 'multipart/form-data',
                        type: 'POST',
                        url: '<?php echo e(route("system.setting.dummydata")); ?>',
                        cache: false,
                        contentType: false,
                        processData: false,
                        success: function(resp) {
                            $("#dvloader").hide();
                            get_responce_message(resp, '', '<?php echo e(route("system.setting.index")); ?>');
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            $("#dvloader").hide();
                            toastr.error(errorThrown, textStatus);
                        }
                    });
                }
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        }
        function clean_database() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                if (confirm("<?php echo e(__('label.do_you_confirm_clean_the_database')); ?>")) {

                    $("#dvloader").show();
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        enctype: 'multipart/form-data',
                        type: 'POST',
                        url: '<?php echo e(route("system.setting.cleandatabase")); ?>',
                        cache: false,
                        contentType: false,
                        processData: false,
                        success: function(resp) {
                            $("#dvloader").hide();
                            get_responce_message(resp, '', '<?php echo e(route("system.setting.index")); ?>');
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            $("#dvloader").hide();
                            toastr.error(errorThrown, textStatus);
                        }
                    });
                }
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/admin/system_setting/index.blade.php ENDPATH**/ ?>