<?php $__env->startSection('content'); ?>
    <div class="h-100 d-flex login-bg">
        <div class="app-logo text-center">
            <h1 class="primary-color"><?php echo e(App_Name()); ?></h1>
        </div>
        <div class="app-login-box">
            <h5 class="mb-0 font-weight-bold">
                <span class="d-block mb-2"><?php echo e(__('label.welcome_back_producer')); ?></span>
                <span><?php echo e(__('label.please_sign_in_to_your_account')); ?></span>
            </h5>

            <?php
                $emailValue = env('DEMO_MODE') == 'ON' ? 'producer@producer.com' : '';
                $passwordValue = env('DEMO_MODE') == 'ON' ? 'producer' : '';
            ?>
            <form id="login_form">
                <div class="form-row mt-4">
                    <div class="col-md-12">
                        <div class="position-relative form-group">
                            <label><?php echo e(__('label.email')); ?></label>
                            <input name="email" type="email" value="<?php echo e($emailValue); ?>" class="form-control" placeholder="<?php echo e(__('label.email_here')); ?>" autofocus>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="position-relative form-group">
                            <label><?php echo e(__('label.password')); ?></label>
                            <input name="password" type="password" value="<?php echo e($passwordValue); ?>" placeholder="<?php echo e(__('label.password_here')); ?>" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="form-row mt-4">
                    <div class="col-sm-12 text-center text-sm-left">
                        <button class="btn btn-default my-2 btn-block" onclick="save_login()" type="button"><?php echo e(__('label.login')); ?></button>
                    </div>
                </div>
            </form>
            <?php if( env('DEMO_MODE') == 'ON'): ?> 
                <hr>
                <h6>
                    <?php echo e(__('label.if_you_cannot_login_then')); ?><a href="<?php echo e(env('APP_URL'). '/public/producer/login'); ?>" target="_blank" class="btn-link"><?php echo e(__('label.click_here')); ?></a>
                </h6>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>
        function save_login() {
            $("#dvloader").show();
            var formData = new FormData($("#login_form")[0]);
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: '<?php echo e(route("producer.save.login")); ?>',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(resp) {
                    $("#dvloader").hide();
                    get_responce_message(resp, 'login_form', '<?php echo e(route("producer.dashboard")); ?>');
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    $("#dvloader").hide();
                    toastr.error(errorThrown, textStatus);
                }
            });
        }

        // Press Enter Key & Save Form
        $('#login_form').keypress((e) => { 
            // Enter key corresponds to number 13 
            if (e.which === 13) { 
                save_login();
            } 
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('producer.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/producer/login/login.blade.php ENDPATH**/ ?>