<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-6 d-flex flex-column justify-content-center">
            <div class="install-card">

                <!-- Alert MSG -->
                <?php if(session()->has('error')): ?>
                    <div class="alert alert-danger alert-block">
                        <button type="button" class="close" data-dismiss="alert" title="Remove">X</button>
                        <strong><?php echo e(Session::get('error')); ?></strong>
                    </div>
                <?php elseif(session()->has('success')): ?>
                    <div class="alert alert-danger alert-block">
                        <button type="button" class="close" data-dismiss="alert" title="Remove">X</button>
                        <strong><?php echo e(Session::get('success')); ?></strong>
                    </div>
                <?php endif; ?>

                <h1 class="primary-color install-title"><?php echo e(__('label.import_software_database')); ?></h1>
                <h1 class="install_sub_title"><?php echo e(__('label.database_connected')); ?></h1>

                <?php if($backup == 0): ?>
                    <h1 class="install_text">Click "<b>Import Database</b>" to begin. The import process may take some time.</h1>
                    <a href="<?php echo e(route('import_sql')); ?>" class="btn btn-install" onclick="showLoder()"><?php echo e(__('label.import_database')); ?><i class="fa-solid fa-upload ml-2"></i></a>                
                <?php else: ?>
                    <h1 class="install_text">Before Proceeding, It's highly recommended to download a <b>BACKUP</b> of your current <b>DATABASE.</b> This ensures you can revert to the previous version if needed. Click "<b>Import Database</b>" to begin. The import process may take some time.</h1>
                    <a href="<?php echo e(route('import_sql')); ?>" class="btn btn-install mr-3" onclick="showLoder()"><?php echo e(__('label.import_database')); ?><i class="fa-solid fa-upload ml-2"></i></a>
                    <a href="<?php echo e(route('backup_db', ['token'=>bcrypt('backup_db')])); ?>" onclick="return confirm('<?php echo e(__('label.you_want_to_download_this_sql_file')); ?>')" class="btn btn-install-cancel"><?php echo e(__('label.backup_database')); ?><i class="fa-solid fa-download ml-2"></i></a>
                <?php endif; ?>

                <!-- Footer -->
                <?php echo $__env->make('installation.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
        </div>
        <div class="col-lg-6 install-bg-img d-none d-lg-block">
            <img src="<?php echo e(asset('assets/imgs/install_bg.png')); ?>" alt="Software Installation">
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('installation.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/installation/step4.blade.php ENDPATH**/ ?>